
#ifndef _1_CRYS_EXT_ATP_RND_Acceptance_h_H
#define _1_CRYS_EXT_ATP_RND_Acceptance_h_H


/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */



#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Sun Mar 06 20:42:10 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_Ext_ATP_RND_Acceptance.h#1:incl:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */


/******** Defines ***********/
/******** Enums ***********/
/******** Typedefs  ***********/
/******** Structs  **********/
typedef struct TST_RND_TestDataStruct{	
	DxUint8_t 					TST_RND_Output1[TST_MAX_DATA_VEC_SIZE_IN_BYTS];
	DxUint8_t 					TST_RND_Output2[TST_MAX_DATA_VEC_SIZE_IN_BYTS];
} TST_RND_TestDataStruct;
/******** Public Variables ********/
/******** Public Functions ********/
/***************************
 * Function Name:                                                           
 *  CRYS_Ext_ATP_RND_Acceptance_No_Reset        
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for Random API's 
 *  Generating different randoms in verious sizes                       
 *                                  
 * Algorithm:       
 * 1. Call the CRYS_RND_GenerateVector function to generate a random value
 * 2. Call the CRYS_RND_GenerateVector to generate a random second random value
 * 3. Compare the random numbers and verify the are different                                               
 *
 **************************/ 
CRYSError_t CRYS_Ext_ATP_RND_Acceptance_No_Reset ( void );

/***************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_RND_Acceptance_No_Reset        
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for Random API's 
 *  Generating different randoms in various sizes   
 *  With Seed reset before any generation                   
 *                                  
 * Algorithm:       
 * 1. Call the CRYS_RND_GenerateVector function to generate a random value
 * 2. Call the CRYS_RND_GenerateVector to generate a random second random value
 * 3. Compare the random numbers and verify the are different                                               
 *
 **************************/                                
CRYSError_t CRYS_Ext_ATP_RND_Reset ( void );



#ifdef __cplusplus
}
#endif

#endif




